/*****************************************************************************
*  LPC15xx SCT demo
*  Use SCT3 to generate a center aligned PWM signal
*  LPC15xx - SCT0/1 support: – 8 inputs
*                            – 10 outputs
*                            – 16 match/capture registers
*                            – 16 events
*                            – 16 states
*            SCT2/3 support: – 3 inputs
*                            – 6 outputs
*                            – 8 match/capture registers
*                            – 10 events
*                            – 10 states
*****************************************************************************/
#include "LPC15xx.h"

void SCT3_Init(void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= EN1_SCT3;                // enable the SCT3 clock

    LPC_SCT3->CONFIG |= (1 << 17);                         // two 16-bit timers, auto limit
    LPC_SCT3->CTRL_L |= (1 << 4) | ((6-1) << 5);           // Bidir mode, prescaler = 6, SCT clock = 2 MHz

    LPC_SCT3->MATCH[0].L     = 10-1;                       // match 0 @ 10/2MHz = 5 usec (100 KHz PWM freq)
    LPC_SCT3->MATCHREL[0].L  = 10-1;
    LPC_SCT3->MATCH[1].L     = 5;                          // match 1 used for duty cycle (in 10 steps)
    LPC_SCT3->MATCHREL[1].L  = 5;

    LPC_SCT3->EVENT[0].STATE = 0xFFFF;                     // event 0 happens in all states
    LPC_SCT3->EVENT[0].CTRL  = (1 << 0) | (1 << 12);       // match 1 condition only

//    LPC_SCT3->OUT[0].SET     = (1 << 0);                   // event 0 will set SCT3_OUT0
    LPC_SCT3->OUT[0].CLR     = (1 << 0);                   // event 0 will clear SCT3_OUT0
    LPC_SCT3->OUTPUTDIRCTRL  = (0x1 << 0);                 // reverse output 0 set when down counting

    LPC_SCT3->CTRL_L        &= ~(1 << 2);                  // unhalt it by clearing bit 2 of CTRL reg
}
